      // Lista de domínios comuns
      const emailDomains = [
        "@gmail.com",
        "@hotmail.com",
        "@outlook.com",
        "@yahoo.com",
        "@icloud.com",
      ];

      const emailInput = document.getElementById("email");
      const suggestionsDiv = document.getElementById("emailSuggestions");

      emailInput.addEventListener("input", function (e) {
        const value = e.target.value;

        // Limpa sugestões anteriores
        suggestionsDiv.innerHTML = "";

        // Se não tiver @, mostra sugestões
        if (value && !value.includes("@")) {
          emailDomains.forEach((domain) => {
            const suggestion = document.createElement("div");
            suggestion.className = "email-suggestion";
            suggestion.textContent = value + domain;

            suggestion.addEventListener("click", () => {
              emailInput.value = suggestion.textContent;
              suggestionsDiv.innerHTML = "";
              emailInput.focus();
            });

            suggestionsDiv.appendChild(suggestion);
          });
        }
      });

      // Fecha sugestões quando clicar fora
      document.addEventListener("click", (e) => {
        if (!e.target.closest(".email-input-wrapper")) {
          suggestionsDiv.innerHTML = "";
        }
      });