	// Função para capturar os parâmetros GET da URL atual
	function getUrlParams() {
		const params = new URLSearchParams(window.location.search);
		let paramsObject = {};
		params.forEach((value, key) => {
			paramsObject[key] = value;
		});
		return paramsObject;
	}

	// Função para adicionar os parâmetros GET aos links clicáveis
	function appendParamsToLinks() {
		const params = getUrlParams();  // Obtém os parâmetros da URL atual
		const links = document.querySelectorAll('a');  // Seleciona todos os links na página

		// Para cada link, adiciona os parâmetros GET à URL
		links.forEach(link => {
			const url = new URL(link.href);  // Cria um objeto URL a partir do href do link
			Object.keys(params).forEach(key => {
				url.searchParams.set(key, params[key]);  // Adiciona ou atualiza os parâmetros GET
			});
			link.href = url.toString();  // Atualiza o atributo href do link
		});
	}

	//reescrever redirects pra incluir parametros
	function redirectWithParams(baseUrl) {
		const params = getUrlParams();
		const url = new URL(baseUrl, window.location);

		Object.keys(params).forEach(key => {
			url.searchParams.set(key, params[key]);
		});

		window.location.href = url.toString();
	}

  	// Chama a função de adicionar parametros ao carregar a página
	window.addEventListener('load', appendParamsToLinks);	