<?php
include_once('./nlo-config.php');

$upsell = "./up1"; //aqui dentro das aspas vc coloca o link do upsell
$oferta = "vegacheckout";

$produto_nome = "Kit 50 Peças";
$produto_desc = "Peças Magnéticas Minecraft";
$produto_img = "./images/produto.png";

$valor = "28.30";
$valor_exibicao = "R$ " . number_format($valor, 2, ',', '.');

$frete_ativo = 0;
$fretes = [
	[
		'nome' => 'Correios',
		'valor_centavos' => 1990,
		'prazo_estimado' => '10 a 15 dias úteis'
	],
	[
		'nome' => 'Sedex',
		'valor_centavos' => 2340,
		'prazo_estimado' => '8 a 12 dias úteis'
	],
	[
		'nome' => 'Jadlog',
		'valor_centavos' => 2790,
		'prazo_estimado' => '7 a 10 dias úteis'
	]
]

// Pega CPF (ou "document") via GET
if (isset($_GET['cpf']) && !empty($_GET['cpf'])) {
    $cpf = urldecode($_GET['cpf']);
} elseif (isset($_GET['document']) && !empty($_GET['document'])) {
    $cpf = urldecode($_GET['document']);
};

if (isset($_GET['email']) && !empty($_GET['email'])) {
    $email = urldecode($_GET['email']);
};

// Pega CPF (ou "document") via GET
if (isset($_GET['nome']) && !empty($_GET['nome'])) {
    $nome = urldecode($_GET['nome']);
} elseif (isset($_GET['name']) && !empty($_GET['name'])) {
    $nome = urldecode($_GET['name']);
};

// Pega número de telefone (ou "phone") via GET
if (isset($_GET['telefone']) && !empty($_GET['telefone'])) {
    $telefone = urldecode($_GET['telefone']);
} elseif (isset($_GET['phone']) && !empty($_GET['phone'])) {
    $telefone = urldecode($_GET['phone']);
};

$upsell = $upsell . "?cpf=" . $cpf . "&nome=" . $nome . "&telefone=" . $telefone;
?>

<!DOCTYPE html>
<html lang="pt-BR">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Oferta Especial - Checkout</title>
    <meta name="description" content="Plataforma de pagamentos" />
    <!-- <link
      rel="icon"
      href="favicon.png"
      type="image/png"
    /> -->
	<!-- <link rel="icon" type="image/x-icon" href="./images/favicon.ico" /> -->
    <link rel="stylesheet" href="css/styles.css" />
    <link
      href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap"
      rel="stylesheet"
    />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link
      href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700&display=swap"
      rel="stylesheet"
    />
    <script src="https://unpkg.com/@phosphor-icons/web"></script>
  </head>
  <style>
  .texto-promocional {
	font-family: 'Inter', sans-serif;
	font-style: normal;
	font-size: 0.875rem;
	line-height: calc(1.25/.875);
	font-weight: 600;
	color: #ffffff;
	background-color: var(--primary-default);
	background-color: #393939;
	box-sizing: border-box;
	display: flex;
	width: 100%;
	align-items: center;
	padding: 1rem .5rem;
	text-align: center;
	justify-content:center;
}

.texto-promocional span {
	max-width:48rem;
}

input::-webkit-input-placeholder {
    opacity: .20
}

input::-ms-input-placeholder {
    opacity: .20
}

input::placeholder {
    opacity: .20
}

.p-amount {
    color: #a6a6a6;
    font-size: 14px;
}

#botaoGerarPix:disabled {
background-color: #a8d9a1;
cursor: not-allowed;
opacity: 0.7;
}

.input-number {
  display: flex;
  justify-content: space-between;
  align-items: center;
  background: #fff;
  width: 80px;
  height: 32px;
  border-radius: 20px;
}
.input-number input {
  width: 20px;
  height: 30px;
  padding: 0;
  outline: 0;
  box-shadow: none;
  text-align: center;
  font-family: sans-serif;
  font-size: 14px;
  -webkit-appearance: textfield;
  -webkit-background-clip: padding-box;
  -moz-appearance: textfield;
  -moz-background-clip: padding-box;
  appearance: textfield;
  background-clip: padding-box;
  border: none;
  border-radius: 0;
  border-top: solid 1px #e1e1e1;
  border-bottom: solid 1px #e1e1e1;
}
.input-number input::-webkit-inner-spin-button,
.input-number input::-webkit-outer-spin-button {
  -webkit-appearance: none;
}
.input-number button {
  display: flex;
  justify-content: center;
  align-items: center;
  border: none;
  outline: 0;
  width: 30px;
  height: 30px;
  background: #fff;
  transition: all 0.5s;
}
.input-number button:first-child {
  border-radius: 30px 0 0 30px;
  border-top: solid 1px #e1e1e1;
  border-left: solid 1px #e1e1e1;
  border-bottom: solid 1px #e1e1e1;
}
.input-number button:last-child {
  border-radius: 0 30px 30px 0;
  border-top: solid 1px #e1e1e1;
  border-right: solid 1px #e1e1e1;
  border-bottom: solid 1px #e1e1e1;
}
.input-number button:hover {
  background: #fafafa;
}
.input-number button:focus {
  background: #f5f5f5;
}
.input-number button img {
  width: 10px;
}
</style>
  <body class="font-inter">
    <main class="bg-gray-100">
      <div id="checkoutForm">
		<?php if($logo_ativo == 1){ ?>
        <div style="display:flex; text-align: center; padding: 10px 0; background: #f3f3f3; width:100%; justify-content:center; align-items: center; padding: 1.5rem 15px; justify-content: space-between">
          <img src="<?php echo $logo_url; ?>" style="height: 64px; max-width: 150px; object-fit: contain;" />
          <img src="./images/pagamento_seguro.svg" />
        </div>
		<?php }; ?>
		<?php if($exibir_texto == 1){; ?>
			<div class="texto-promocional" style="font-weight:400; padding:16px; background-color:<?php echo $texto_fundo; ?>">
				<span><?php echo $texto; ?></span>
			</div>
		<?php }; ?>
		<?php if($banner_ativo == 1){ ?>
	    <div class="banner" style="width:100%;height:auto; line-height:0; margin: 0.8rem 0">
          <img style="width:100%" src="<?php echo $banner_url; ?>">
        </div>
		<?php }; ?>
        <div class="container">
          <aside class="cart-summary" style="padding:1rem">
<section>
              <div class="cart-header">
                <h2>Seu carrinho</h2>
               
              </div>
              <!-- <div class="cart-item" style="/* border-bottom: 1px solid #e5e7eb; */ padding-bottom: 1rem;margin-bottom: 0.5rem;">
                <div class="item-details">
                  <div class="item-image">
                    <img src="images/sedex.png">
                  </div>
                  <div class="item-info">
                    <span class="item-name">Envio selecionado</span>
                    <div class="item-meta">
                      <span>Cartão 4700 Limite</span>
                    </div>
                  </div>
			  <div class="cart-total">
                <span class="p-amount">1 un.</span>
              </div>
                </div>
              </div> -->
            <div class="cart-item" style="border-bottom: 1px solid #e5e7eb;padding-bottom: 1rem;margin-bottom: 0.5rem;">
                <div class="item-details">
                  <div class="item-image" style="border-radius:4px">
                    <img src="<?php echo $produto_img; ?>">
                  </div>
                  <div class="item-info">
                    <span class="item-name"><?php echo $produto_nome; ?></span>
                    <div class="item-meta">
                      <span><?php echo $produto_desc; ?></span>
                    </div>
                  </div>

              <!-- <div class="cart-subtotal">
                <span>Subtotal</span>
                <span>R$ 00,00</span>
              </div>
              <div class="cart-shipping" id="cartShipping" style="display: none;">
                <span>Frete</span>
                <span id="shippingValue">R$ 32,82</span>
              </div> -->
			  <div class="cart-total">
                <!-- <span>Total</span> -->
                <!-- <span class="p-amount">1 un.</span> -->
                <div class="input-number">

                    <button class="btn-sub">
                        <img src="https://pay.pagamentostiktok.shop/assets/img/minus.svg">
                    </button>

                    <input type="number" value="1" min="1" max="99" step="1">
                    <button type="button" class="btn-add">
                        <img src="https://pay.pagamentostiktok.shop/assets/img/plus.svg">
                    </button>

                </div>
              </div>
                </div>
              </div>
              <div class="cart-subtotal" style="margin-top:1rem; justify-content:unset; flex-direction:column">
                <div style="display:flex;justify-content:space-between">
                <span style="
    font-weight: 400;
    font-size: 14px;
    color: #585858;
">Subtotal</span>
                <span style="
    font-weight: 400;
    font-size: 14px;
    color: #585858;
"><?php echo $valor_exibicao; ?></span>
                </div>
                <div style="display:flex;justify-content:space-between">
                <span style="
    font-weight: 400;
    font-size: 14px;
    color: #585858;
">Frete</span>
                <span id="valorFrete" style="
    font-weight: 400;
    font-size: 14px;
    color: #585858;
">-</span>
                </div>
              </div>
              <div class="cart-total">
                <span>Total</span>
                <strong id="totalValue"><?php echo $valor_exibicao; ?></strong>
              </div></section>
          </aside>
          <form class="checkout-form" id="paymentForm">
            <div class="form-section" style="padding:1rem">
              <h2>Identificação</h2>
              <div class="form-grid">
				<div class="form-group">
                  <label for="email">E-mail</label>
                  <div class="email-input-wrapper">
                    <input
                      type="email"
                      id="email"
                      name="email"
                      placeholder="email@gmail.com"
                      required
                      autocomplete="off"
                    <?php if($email && !empty($email)){echo "value='$email'";}; ?>
                    />
                    <div id="emailSuggestions" class="email-suggestions"></div>
                  </div>
                </div>
                <div class="form-group">
                  <label for="phone">Telefone</label>
                  <input
                    type="tel"
                    id="phone"
                    name="phone"
                    placeholder="(99) 99999-9999"
					<?php if($telefone && !empty($telefone)){echo "value='$telefone'";}; ?>
                    required
                  />
                </div>
                <div class="form-group">
                  <label for="name">Nome completo</label>
                  <input
                    type="text"
                    id="name"
                    name="name"
                    placeholder="Seu nome completo"
					<?php if($nome && !empty($nome)){echo "value='$nome'";}; ?>
                    required
                    maxlength="30"
                  />
                </div>
                <div class="form-group">
                  <label for="cpf">CPF</label>
                  <input
                    type="text"
                    id="cpf"
                    name="cpf"
                    placeholder="123.456.789-12"
					<?php if($cpf && !empty($cpf)){echo "value='$cpf'";}; ?>
					required
                  />
                </div>
              </div>
            </div>

            <div class="form-section payment-section" style="padding:1rem">
              <h2>Pagamento</h2>
              <div class="payment-method">
                <div class="payment-option">
                  <img
                    src="images/card-pix.svg"
                    alt="PIX"
                    class="payment-icon"
                  />
                  <span class="payment-label">PIX</span>
                </div>
              </div>
              <div style="border: 1px solid #ddd; padding: 1rem; margin-bottom:16px; border-radius:4px"><span style="font-family: Inter;
    font-style: normal;
    font-weight: 400;
    font-size: 16px;
    color: #7e7e7e;
    text-align: left;">
                        Ao selecionar o Pix, você será encaminhado para um ambiente seguro para finalizar
                        seu pagamento.
                    </span></div>
              <button id="botaoGerarPix" type="submit" class="submit-button" style="background-color:#23d07d;padding:16px 24px; cursor:pointer;    border-radius: 4px;
    text-transform: uppercase;
    font: normal normal 700 16px / 20px Inter;">Gerar PIX</button>
            </div>
          </form>
			<?php if($prova_social_ativa == 1){ ?>
				<div class="prova-social-container" style="background-color:white;border-radius:12px; padding:1rem; margin-top:0">
					<?php
                		$total = count($provas_sociais);
                		foreach ($provas_sociais as $index => $prova){ ?>
					<div class="prova-social" style="padding:0">
					  <div class="avatar">
						<img src="<?php echo $prova['avatar']; ?>" alt="Avatar">
					  </div>
					  <div class="conteudo">
						<div class="estrelas">
						  <span class="estrela-icon">★</span><span class="estrela-icon">★</span><span class="estrela-icon">★</span><span class="estrela-icon">★</span><span class="estrela-icon">★</span>
						</div>
						<div class="nome"><?php echo $prova['nome']; ?></div>
						<div class="mensagem"><?php echo $prova['mensagem']; ?></div>
					  </div>
					</div>
			<?php 
			if ($index < $total - 1) {
				echo '<hr style="/*margin-top: 1rem; margin-bottom: 1rem;*/ border: 0; border-top: 1px solid rgba(0, 0, 0, .1); width: 100%; box-sizing: content-box; height: 0; overflow: visible;">';
			}
			?>
		<?php }; ?>
				</div>
			<?php }; ?>
        </div>
      </div>


      <!-- Tela do PIX (inicialmente oculta) -->
		<?php if($logo_ativo == 1){ ?>
        <div id="pixscreenheader" style="display:flex; text-align: center; background: white; width:100%; justify-content:center; align-items: center; padding: 5px 30px; justify-content: space-between; display:none">
          <img src="<?php echo $logo_url; ?>" style="height: 64px; max-width: 150px; object-fit: contain;">
          <img src="./images/pagamento_seguro.svg">
        </div>
		<?php }; ?>
      <div id="pixScreen" style="display: none">
        <h2 style="font: normal normal bold 18px / 23px Inter; color: #4b4b4b">
          <!-- Falta pouco! Para finalizar, escaneie o QR Code abaixo. -->
        Falta pouco! Para finalizar a compra, efetue o pagamento com PIX!
        </h2>
		<div class="pix-container">
			<div class="qr-code-container" style="background: white;border-radius: 8px;border: 1px solid #9f9f9f; display: none">
			  <div id="qrcode"></div>
			</div>

            <p class="pix-copy-text" style="
                font: normal normal normal 16px/18px Inter;
                color: black;
            ">
			  <!-- Se preferir, pague com a opção PIX Copia e Cola -->
			   Copie a chave abaixo e utilize a <br>opção <b>PIX Copia e Cola</b>:
			</p>

			<div class="pix-code-container">
			  <input type="text" id="pixCode" readonly style="background: white;
    font: normal normal normal 16px / 18px Inter;
    border: 1px solid #9f9f9f;
    padding: 13px 15px;
    border-radius: 8px;" />
			  <button id="copyPixButton" class="copy-button" style="border-radius: 4px;padding: 14px 28px;">
				<svg viewBox="0 0 24 24" width="24" height="24">
				  <path
					d="M20 2H10c-1.103 0-2 .897-2 2v4H4c-1.103 0-2 .897-2 2v10c0 1.103.897 2 2 2h10c1.103 0 2-.897 2-2v-4h4c1.103 0 2-.897 2-2V4c0-1.103-.897-2-2-2zM4 20V10h10l.002 10H4zm16-6h-4v-4c0-1.103-.897-2-2-2h-4V4h10v10z"
				  ></path>
				</svg>
				COPIAR CÓDIGO
			  </button>
			</div>
		</div>
					<div class="payment-instructions" style="margin-top:1.3rem">
<h3 style="
    text-align: center;
    font-weight: 400;
    margin-bottom: 20px; color:#393939;
">Valor a ser pago: <span style="color:#41c286; font-weight:600; margin-left:10px"><?php echo $valor_exibicao; ?></span></h3>
			  <h3>Instruções para pagamento</h3>
			  <div class="instruction-step">
				<div class="step-icon">
				  <i class="ph ph-bank"></i>
				</div>
				<p>Abra o app do seu banco e entre no ambiente Pix</p>
			  </div>
			  <div class="instruction-step">
				<div class="step-icon">
				  <i class="ph ph-qr-code"></i>
				</div>
				<p>
				  Escolha Pagar com QR Code e aponte a câmera para o código ao lado.
				</p>
			  </div>
			  <div class="instruction-step">
				<div class="step-icon">
				  <i class="ph ph-check-circle"></i>
				</div>
				<p>Confirme as informações e finalize seu pagamento.</p>
			  </div>
			</div>
      </div>

      <!-- Adicione após o form e antes da tela do PIX -->
      <div id="loadingScreen" class="loading-screen" style="display: none">
        <div class="loading-content">
          <div class="loading-spinner"></div>
          <h2>Gerando seu PIX...</h2>
          <p>Aguarde um momento</p>
        </div>
      </div>
    </main>

    <footer>
      <button class="security-button">
<img src="./images/safe.svg" alt="Green Shield Icon" style="margin-right:10px">
        <!-- <svg viewBox="0 0 24 24" class="security-icon">
          <path
            d="M11.488 21.754c.294.157.663.156.957-.001 8.012-4.304 8.581-12.713 8.574-15.104a.988.988 0 0 0-.596-.903l-8.05-3.566a1.005 1.005 0 0 0-.813.001L3.566 5.747a.99.99 0 0 0-.592.892c-.034 2.379.445 10.806 8.514 15.115zM8.674 10.293l2.293 2.293 4.293-4.293 1.414 1.414-5.707 5.707-3.707-3.707 1.414-1.414z"
          ></path>
        </svg> -->
        Ambiente seguro
      </button>
    </footer>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
	<script>
	const upsellUrl = "<?php echo $upsell; ?>";
	const oferta = "<?php echo $oferta; ?>";
    let valorTotal = <?php echo $valor; ?>;

	// Função para aplicar máscara de CPF
	function maskCPF(input) {
		let value = input.value.replace(/\D/g, "");
		value = value.replace(/(\d{3})(\d)/, "$1.$2");
		value = value.replace(/(\d{3})(\d)/, "$1.$2");
		value = value.replace(/(\d{3})(\d{1,2})$/, "$1-$2");
		input.value = value;
	}

    // Função para aplicar máscara de telefone
	function maskPhone(input) {
		let value = input.value.replace(/\D/g, "");
		if (value.length > 10) {
			value = value.replace(/^(\d{2})(\d{5})(\d{4}).*/, "($1) $2-$3");
		} else {
			value = value.replace(/^(\d{2})(\d{4})(\d{0,4}).*/, "($1) $2-$3");
		}
		input.value = value;
	}

	// Validação de nome e telefone, habilita/desabilita o botão
	function validarCampos() {
		const nomeInput = document.getElementById("name");
		const phoneInput = document.getElementById("phone");
        const emailInput = document.getElementById("email");
		const cpfInput = document.getElementById("cpf");
		const botaoGerarPix = document.getElementById("botaoGerarPix");

		const nome = nomeInput.value.trim();
		//const nomeValido = /^[A-Za-zÀ-ÿ\s]{7,}$/.test(nome);
        const nomeValido = /^[A-Za-zÀ-ÿ]{2,}(?:\s+[A-Za-zÀ-ÿ]{2,})+$/.test(nome);

		const telefone = phoneInput.value.replace(/\D/g, "");

        const email = emailInput.value.trim();
        const emailValido = /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);

		const cpf = cpfInput.value.replace(/\D/g, "");

		botaoGerarPix.disabled = !(nomeValido && (telefone.length === 10 || telefone.length === 11) && emailValido && cpf.length === 11);
	}

	// Adiciona os listeners para os campos
	document.addEventListener("DOMContentLoaded", function () {
      const cpfInput = document.getElementById("cpf");
      const phoneInput = document.getElementById("phone");
      const nomeInput = document.getElementById("name");
      const emailInput = document.getElementById("email");

		//mascara os valores quando a página carregar
		maskCPF(cpfInput);
		maskPhone(phoneInput);

		cpfInput.addEventListener("input", function () {
			maskCPF(this);
			validarCampos();
		});

		phoneInput.addEventListener("input", function () {
			maskPhone(this);
			validarCampos();
		});

		nomeInput.addEventListener("input", function () {
			this.value = this.value.replace(/[^A-Za-zÀ-ÿ\s]/g, '');
			validarCampos();
		});

        emailInput.addEventListener("input", function () {
            validarCampos();
        });

      // Limita o tamanho máximo dos campos
      cpfInput.maxLength = 14; // 000.000.000-00
      phoneInput.maxLength = 15; // (00) 00000-0000

      validarCampos(); // Valida campos ao carregar página
	});

	document
	.getElementById("paymentForm")
	.addEventListener("submit", async function (e) {
		e.preventDefault();

		// Mostra a tela de loading
		document.getElementById("loadingScreen").style.display = "flex";

		const formData = {
			acao: "criar",
			oferta: oferta,
			valor: valorTotal,
			nome: document.getElementById("name").value,
			email: document.getElementById("email").value,
			cpf: document.getElementById("cpf").value.replace(/\D/g, ""),
			telefone: document.getElementById("phone").value.replace(/\D/g, ""),
			utm: encodeURIComponent(new URLSearchParams(window.location.search).toString()) || "utm_source=direct"
		};

		const url = new URL("api/gateway.php", window.location);
		Object.keys(formData).forEach(key => {
			url.searchParams.set(key, formData[key]);
		});

		try {
			const response = await fetch(url);
			const data = await response.json();

			if (data.erro) { //Se houver erro na API
				throw new Error(data.erroMsg || "Erro desconhecido na resposta da API");
			}

			if (data.pixCode && data.payment_id) {
				// Esconde a tela de loading
				document.getElementById("loadingScreen").style.display = "none";
				// Oculta o formulário e mostra a tela do PIX
				document.getElementById("checkoutForm").style.display = "none";
                document.getElementById("pixscreenheader").style.display = "flex";
				document.getElementById("pixScreen").style.display = "block";

				// Gera o QR Code
				new QRCode(document.getElementById("qrcode"), data.pixCode);

				// Preenche o código PIX
				document.getElementById("pixCode").value = data.pixCode;

				// Inicia verificação do pagamento
				startPaymentCheck(data.payment_id);
			}
		} catch (error) {
			// Esconde a tela de loading em caso de erro
			document.getElementById("loadingScreen").style.display = "none";
			console.error("Erro ao gerar PIX:", error);
			alert("Erro ao gerar o PIX: " + error.message + "\nPor favor, tente novamente.");
		}
	});

    // Função para copiar o código PIX
    document
      .getElementById("copyPixButton")
      .addEventListener("click", function () {
        const pixCode = document.getElementById("pixCode");
        pixCode.select();
        document.execCommand("copy");
        this.innerHTML =
          '<svg viewBox="0 0 24 24" width="24" height="24"><path d="M20 2H10c-1.103 0-2 .897-2 2v4H4c-1.103 0-2 .897-2 2v10c0 1.103.897 2 2 2h10c1.103 0 2-.897 2-2v-4h4c1.103 0 2-.897 2-2V4c0-1.103-.897-2-2-2zM4 20V10h10l.002 10H4zm16-6h-4v-4c0-1.103-.897-2-2-2h-4V4h10v10z"></path></svg>COPIADO!';
        setTimeout(() => {
          this.innerHTML =
            '<svg viewBox="0 0 24 24" width="24" height="24"><path d="M20 2H10c-1.103 0-2 .897-2 2v4H4c-1.103 0-2 .897-2 2v10c0 1.103.897 2 2 2h10c1.103 0 2-.897 2-2v-4h4c1.103 0 2-.897 2-2V4c0-1.103-.897-2-2-2zM4 20V10h10l.002 10H4zm16-6h-4v-4c0-1.103-.897-2-2-2h-4V4h10v10z"></path></svg>COPIAR CÓDIGO';
        }, 2000);
      });

	// Função para verificar o status do pagamento
	function startPaymentCheck(payment_id) {
		const checkPayment = async () => {
			const url = new URL("api/gateway.php", window.location);
			url.searchParams.set("acao", "verificar");
			url.searchParams.set("payment_id", payment_id);

			try {
				const response = await fetch(url);
				const data = await response.json();
				if (data?.status === "APPROVED" || data?.status === "completed" || data?.status === "COMPLETED") {
					const upsell = new URL(upsellUrl, window.location.href);
					const currentParams = new URLSearchParams(window.location.search);

					// Adiciona os parâmetros da página atual no upsellUrl (sem sobrescrever os já existentes no upsellUrl)
					for (const [key, value] of currentParams.entries()) {
						if (!upsell.searchParams.has(key)) {
							upsell.searchParams.set(key, value);
						}
					}

					//upsell.searchParams.set("upsell", "1"); // Força o parâmetro upsell=1, mesmo que já exista
					window.location.href = upsell.toString(); // Redireciona
				}
			} catch (error) {
				console.error("Erro ao verificar pagamento:", error);
			}
		};

		setInterval(checkPayment, 10000); // Verifica se o pix foi pago a cada 10 segundos
	}

    // Lista de domínios comuns
    const emailDomains = [
      "@gmail.com",
      "@hotmail.com",
      "@outlook.com",
      "@yahoo.com",
      "@icloud.com",
    ];

    const emailInput = document.getElementById("email");
    const suggestionsDiv = document.getElementById("emailSuggestions");

    emailInput.addEventListener("input", function (e) {
      const value = e.target.value;

      // Limpa sugestões anteriores
      suggestionsDiv.innerHTML = "";

      // Se não tiver @, mostra sugestões
      if (value && !value.includes("@")) {
        emailDomains.forEach((domain) => {
          const suggestion = document.createElement("div");
          suggestion.className = "email-suggestion";
          suggestion.textContent = value + domain;

          suggestion.addEventListener("click", () => {
            emailInput.value = suggestion.textContent;
            suggestionsDiv.innerHTML = "";
            emailInput.focus();
          });

          suggestionsDiv.appendChild(suggestion);
        });
      }
    });


    // Fecha sugestões quando clicar fora
    document.addEventListener("click", (e) => {
      if (!e.target.closest(".email-input-wrapper")) {
        suggestionsDiv.innerHTML = "";
      }
    });

	/*
	email.js
	  */
    </script>
  </body>
</html>
